//
//  table__s_b_i_x.h
//  GSFontTools
//
//  Created by Georg Seifert on 01.08.13.
//
//

#import "TTable.h"

@class SBIXBitmapSet;
@class SBIXBitmap;

@interface table__s_b_i_x : TTable {
	uint16_t _version;
	uint16_t _flags;
	NSMutableDictionary * _bitmapSets;
}
@property (nonatomic) uint16_t version;
@property (nonatomic) uint16_t flags;
@property (nonatomic, retain) NSMutableDictionary* bitmapSets;

- (void) insertObject:(SBIXBitmapSet*)bitmapSet inBitmapSetsForKey:(id) Key ;

@end

@interface SBIXBitmapSet : NSObject {
	uint16_t _size;
	uint16_t _resolution;
	NSMutableDictionary * _bitmaps;
}
@property (nonatomic) uint16_t size;
@property (nonatomic) uint16_t resolution;
@property (nonatomic, retain) NSMutableDictionary* bitmaps;
- (void) insertObject:(SBIXBitmap*)bitmap inBitmapsForKey:(id)Key;
- (BOOL) decompile:(NSData*)Data pos:(NSUInteger)Start font:(TTFont*)Font error:(NSError**)error ;
- (NSData*) compile:(TTFont*)Font error:(NSError **)error;
- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*)Font;
@end

@interface SBIXBitmap : NSObject {
	uint32_t _reserved;
	NSString * _format;
	NSData* _imageData;
	uint16_t _referenceGlyphID;
}
@property (nonatomic, retain) NSData* imageData;
@property (nonatomic) uint16_t referenceGlyphID;
@property (nonatomic, retain) NSString* format;

- (BOOL) decompile:(NSData*)Data pos:(NSUInteger)pos lenght:(NSUInteger)Length font:(TTFont*)Font error:(NSError**)error ;
- (BOOL) compile:(NSMutableData*)Data font:(TTFont*)Font error:(NSError**)error ;
- (void) toXML:(GSXMLWriter*)Writer font:(TTFont*)Font;
@end